// +------------------------------------------------------------------+
// |             ____ _               _        __  __ _  __           |
// |            / ___| |__   ___  ___| | __   |  \/  | |/ /           |
// |           | |   | '_ \ / _ \/ __| |/ /   | |\/| | ' /            |
// |           | |___| | | |  __/ (__|   <    | |  | | . \            |
// |            \____|_| |_|\___|\___|_|\_\___|_|  |_|_|\_\           |
// |                                                                  |
// | Copyright Mathias Kettner 2014             mk@mathias-kettner.de |
// +------------------------------------------------------------------+
//
// This file is part of Check_MK.
// The official homepage is at http://mathias-kettner.de/check_mk.
//
// check_mk is free software;  you can redistribute it and/or modify it
// under the  terms of the  GNU General Public License  as published by
// the Free Software Foundation in version 2.  check_mk is  distributed
// in the hope that it will be useful, but WITHOUT ANY WARRANTY;  with-
// out even the implied warranty of  MERCHANTABILITY  or  FITNESS FOR A
// PARTICULAR PURPOSE. See the  GNU General Public License for more de-
// tails. You should have  received  a copy of the  GNU  General Public
// License along with GNU Make; see the file  COPYING.  If  not,  write
// to the Free Software Foundation, Inc., 51 Franklin St,  Fifth Floor,
// Boston, MA 02110-1301 USA.

#include "StatusSpecialIntColumn.h"
#include "MonitoringCore.h"
#include "Row.h"
#include "mk_inventory.h"
#include "nagios.h"

int32_t StatusSpecialIntColumn::getValue(Row /* row */,
                                         const contact* /* auth_user */) const {
    switch (_type) {
        case Type::mk_inventory_last:
            // Check_MK Inventory touches the file ".last" after each inventory
            return static_cast<int32_t>(
                mk_inventory_last(_mc->mkInventoryPath() + "/.last"));
        case Type::num_queued_notifications:
            return static_cast<int32_t>(_mc->numQueuedNotifications());
        case Type::num_queued_alerts:
            return static_cast<int32_t>(_mc->numQueuedAlerts());
    }
    // never reached, make -Wall happy
    return 0;
}
